/*
 * Decompiled with CFR 0.152.
 */
package io.tsduck;

import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

class NativeLibrary {
    private static final String pathSeparator = System.getProperty("path.separator");
    private static final String osName = System.getProperty("os.name").toLowerCase().replaceAll(" ", "");
    private static final boolean isWindows = osName.startsWith("win") || osName.startsWith("nt");
    private static final boolean isMac = osName.startsWith("mac");
    private static final String libName = "tsduck";
    private static boolean loaded = false;

    NativeLibrary() {
    }

    private static native void initialize();

    private static String searchLibraryInPath(String string, String string2) {
        if (string != null && string2 != null) {
            String string3 = isWindows ? string2 + ".dll" : (isMac ? "lib" + string2 + ".dylib" : "lib" + string2 + ".so");
            for (String string4 : string.split(pathSeparator)) {
                Path path;
                if (string4.isEmpty() || !Files.exists(path = FileSystems.getDefault().getPath(string4, string3), new LinkOption[0])) continue;
                return path.toString();
            }
        }
        return null;
    }

    public static synchronized void loadLibrary() {
        if (!loaded) {
            String string = null;
            string = NativeLibrary.searchLibraryInPath(System.getenv("TSPLUGINS_PATH"), libName);
            if (string == null && !isWindows) {
                string = NativeLibrary.searchLibraryInPath("/usr/local/lib:/usr/lib:/usr/lib64", libName);
            }
            if (string != null) {
                System.load(string.toString());
            } else {
                System.loadLibrary(libName);
            }
            NativeLibrary.initialize();
            loaded = true;
        }
    }
}

